<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\SystemLogService;

class SystemLogController extends Controller
{
    private $service;

    public function __construct(SystemLogService $service)
    {
        $this->middleware('auth');
        $this->service = $service;
    }

    public function datatable(Request $request) {
        $table = $this->service->dataTable($request);
        return $table;
    }

    public function index() {
        return view('systems_logs.index');
    }
}
