<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\JsonResponse;
use JWTAuth;

class JWT
{
    private const QUERY_PARAMETER = 'pretty';

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        JWTAuth::parseToken()->authenticate();
        $response = $next($request);

        if ($response instanceof JsonResponse) {
            if (!$request->query(self::QUERY_PARAMETER) || $request->query(self::QUERY_PARAMETER) == 'true') {
                $response->setEncodingOptions(JSON_PRETTY_PRINT);
            }
        }

        return $response;
    }
}
