<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CallHistory extends Model
{
    public $table = 'call_histories';

    public $timestamps = false;

    protected $fillable = [
        'userId',
        'platformId',
        'method',
        'service',
        'description'
    ];

    protected $casts = [
        'id'          => 'integer',
        'userId'      => 'integer',
        'platformId'  => 'integer',
        'method'      => 'string',
        'service'     => 'string',
        'description' => 'string',
        'enabled'     => 'boolean',
        'trash'       => 'boolean'
    ];

}
