<?php

namespace App\Services;

use App\Http\Controllers\AppBaseController;
use App\Interfaces\IServices;
use App\Models\ApiError;
use Illuminate\Http\Request;
use App\Models\SystemLog;
use App\Exceptions\AppException;
use Laracasts\Flash\Flash;
use Yajra\Datatables\Datatables;
use Illuminate\Support\Facades\DB;

class SystemLogService extends AppBaseController
{
    public function dataTable(Request $request){

        $apiError =  new ApiError();
        $table = SystemLog::where('trash', false)
        ->leftjoin('users', 'system_logs.userId', '=', 'users.id')
        ->select(
            DB::raw('system_logs.id AS id'),
            DB::raw('system_logs.controller AS controller'),
            DB::raw('system_logs.message AS message'),
            DB::raw('system_logs.userId AS userId'),
            DB::raw('system_logs.created_at AS createdAt'),
            DB::raw('users.name AS userName')
        )->orderBy('system_logs.id', 'DESC')->take(20);

        try {
            return Datatables::of($table)->make(true);

        }catch(AppException $ex ){
            $apiError->setError($ex->getMessage());
            Flash::error(__('Error, intente de nuevo más tarde'));

        }catch(\Exception $ex ){
            $apiError->setError($ex->getMessage());
            Flash::error(__('Error, intente de nuevo más tarde'));
        }

        return $apiError;
    }
}
