@extends('layouts.app')

@section('content')

<div class="content">
    <div class="row">
        <div class="col-3">
            <div class="card">
                <div class="card-header bg-dark text-white d-flex justify-content-between" style="background-color: #102360e0!important;">
                    <span class="font-size-sm text-uppercase font-weight-semibold">CPA_0221</span>
                    <span class="font-size-sm text-uppercase font-weight-semibold">{{date('Y-m-d')}}</span>
                </div>
                <div class="card-body">
                    <figure class="highcharts-figure">
                        <div id="container-speed" class="chart-container"></div>
                        <p class="highcharts-description">
                        </p>
                    </figure>
                </div>
                <div class="card-footer bg-transparent d-flex justify-content-between border-top-0 pt-0">
                </div>
            </div>
        </div>
        <div class="col-3">
            <div class="card">
                <div class="card-header bg-dark text-white d-flex justify-content-between" style="background-color: #102360e0!important;">
                    <span class="font-size-sm text-uppercase font-weight-semibold">CPA_0230</span>
                    <span class="font-size-sm text-uppercase font-weight-semibold">{{date('Y-m-d')}}</span>
                </div>
                <div class="card-body">
                    <figure class="highcharts-figure">
                        <div id="container-rpm" class="chart-container"></div>
                        <p class="highcharts-description">
                        </p>
                    </figure>
                </div>
                <div class="card-footer bg-transparent d-flex justify-content-between border-top-0 pt-0">
                </div>
            </div>
        </div>
        <div class="col-3">
            <div class="card">
                <div class="card-header bg-dark text-white d-flex justify-content-between" style="background-color: #102360e0!important;">
                    <span class="font-size-sm text-uppercase font-weight-semibold">CPA_0231</span>
                    <span class="font-size-sm text-uppercase font-weight-semibold">{{date('Y-m-d')}}</span>
                </div>
                <div class="card-body">
                    <figure class="highcharts-figure">
                        <div id="container-rpm-2" class="chart-container"></div>
                        <p class="highcharts-description">
                        </p>
                    </figure>
                </div>
                <div class="card-footer bg-transparent d-flex justify-content-between border-top-0 pt-0">
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-6">
            <div class="card">
                <div class="card-header bg-dark text-white d-flex justify-content-between" style="background-color: #102360e0!important;">
                    <span class="font-size-sm text-uppercase font-weight-semibold">BARRA</span>
                    <span class="font-size-sm text-uppercase font-weight-semibold">{{date('Y-m-d')}}</span>
                </div>
                <div class="card-body">
                    <figure class="highcharts-figure">
                        <div id="container"></div>
                        <p class="highcharts-description">
                        </p>
                    </figure>
                </div>
                <div class="card-footer bg-transparent d-flex justify-content-between border-top-0 pt-0">
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-xl-6">
            <div class="card">
                <div class="card-header bg-dark text-white d-flex justify-content-between" style="background-color: #102360e0!important;">
                    <span class="font-size-sm text-uppercase font-weight-semibold">INDICADOR</span>
                    <span class="font-size-sm text-uppercase font-weight-semibold">{{date('Y-m-d')}}</span>
                </div>
                <div class="card-body">
                    <figure class="highcharts-figure">
                        <div id="container2"></div>
                        <p class="highcharts-description">
                        </p>
                    </figure>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-xl-6">
            <div class="card">
                <div class="card-header bg-dark text-white d-flex justify-content-between" style="background-color: #102360e0!important;">
                    <span class="font-size-sm text-uppercase font-weight-semibold">Cycle Time</span>
                    <span class="font-size-sm text-uppercase font-weight-semibold">{{date('Y-m-d')}}</span>
                </div>
                <div class="card-body">
                    <figure class="highcharts-figure">
                        <div id="container3"></div>
                        <p class="highcharts-description">
                        </p>
                    </figure>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-xl-6">
            <div class="card">
                <div class="card-header bg-dark text-white d-flex justify-content-between" style="background-color: #102360e0!important;">
                    <span class="font-size-sm text-uppercase font-weight-semibold">Cycle Time</span>
                    <span class="font-size-sm text-uppercase font-weight-semibold">{{date('Y-m-d')}}</span>
                </div>
                <div class="card-body">
                    <figure class="highcharts-figure">
                        <div id="container4"></div>
                        <p class="highcharts-description">
                        </p>
                    </figure>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')

    <script>
        const gaugeOptions = {
            chart: {
                type: 'solidgauge'
            },

            title: null,

            pane: {
                center: ['50%', '85%'],
                size: '140%',
                startAngle: -90,
                endAngle: 90,
                background: {
                    backgroundColor:
                        Highcharts.defaultOptions.legend.backgroundColor || '#fafafa',
                    borderRadius: 5,
                    innerRadius: '60%',
                    outerRadius: '100%',
                    shape: 'arc'
                }
            },

            exporting: {
                enabled: false
            },

            tooltip: {
                enabled: false
            },

            // the value axis
            yAxis: {
                stops: [
                    [0.1, '#55BF3B'], // green
                    [0.5, '#DDDF0D'], // yellow
                    [0.9, '#DF5353'] // red
                ],
                lineWidth: 0,
                tickWidth: 0,
                minorTickInterval: null,
                tickAmount: 2,
                title: {
                    y: -70
                },
                labels: {
                    y: 16
                }
            },

            plotOptions: {
                solidgauge: {
                    borderRadius: 3,
                    dataLabels: {
                        y: 5,
                        borderWidth: 0,
                        useHTML: true
                    }
                }
            }
        };

// The speed gauge
        const chartSpeed = Highcharts.chart(
        'container-speed', Highcharts.merge(gaugeOptions, {
            yAxis: {
                min: 0,
                max: 200,
                title: {
                    text: 'Speed'
                }
            },

            credits: {
                enabled: false
            },

            series: [{
                name: 'Speed',
                data: [80],
                dataLabels: {
                    format:
                    '<div style="text-align:center">' +
                    '<span style="font-size:25px">{y}</span><br/>' +
                    '<span style="font-size:12px;opacity:0.4">km/h</span>' +
                    '</div>'
                },
                tooltip: {
                    valueSuffix: ' km/h'
                }
            }]

        }));

        const chartRpm = Highcharts.chart(
        'container-rpm', Highcharts.merge(gaugeOptions, {
            yAxis: {
                min: 0,
                max: 5,
                title: {
                    text: 'RPM'
                }
            },

            series: [{
                name: 'RPM',
                data: [1],
                dataLabels: {
                    format:
                    '<div style="text-align:center">' +
                    '<span style="font-size:25px">{y:.1f}</span><br/>' +
                    '<span style="font-size:12px;opacity:0.4">' +
                    '* 1000 / min' +
                    '</span>' +
                    '</div>'
                },
                tooltip: {
                    valueSuffix: ' revolutions/min'
                }
            }]

        }));


        Highcharts.chart('container3', {

            title: {
                text: 'INDICADOR',
                align: 'left'
            },

            subtitle: {
                text: '',
                align: 'left'
            },

            yAxis: {
                title: {
                    text: ''
                }
            },

            xAxis: {
                accessibility: {
                    rangeDescription: ''
                }
            },

            legend: {
                layout: 'vertical',
                align: 'right',
                verticalAlign: 'middle'
            },

            plotOptions: {
                series: {
                    label: {
                        connectorAllowed: false
                    },
                    pointStart: 2010
                }
            },

            series: [{
                name: 'AWS1',
                data: [
                    43934, 48656, 65165, 81827, 112143, 142383,
                    171533, 165174, 155157, 161454, 154610, 168960, 171558
                ]
            }, {
                name: 'AWS2',
                data: [
                    24916, 37941, 29742, 29851, 32490, 30282,
                    38121, 36885, 33726, 34243, 31050, 33099, 33473
                ]
            }, {
                name: 'AWS3',
                data: [
                    11744, 30000, 16005, 19771, 20185, 24377,
                    32147, 30912, 29243, 29213, 25663, 28978, 30618
                ]
            }, {
                name: 'AWS4',
                data: [
                    null, null, null, null, null, null, null,
                    null, 11164, 11218, 10077, 12530, 16585
                ]
            }, {
                name: 'AWS5',
                data: [
                    21908, 5548, 8105, 11248, 8989, 11816, 18274,
                    17300, 13053, 11906, 10073, 11471, 11648
                ]
            }],

            responsive: {
                rules: [{
                    condition: {
                        maxWidth: 500
                    },
                    chartOptions: {
                        legend: {
                            layout: 'horizontal',
                            align: 'center',
                            verticalAlign: 'bottom'
                        }
                    }
                }]
            }

        });

        Highcharts.chart('container', {
            chart: {
                type: 'bar'
            },
            title: {
                text: 'Estadistico'
            },
            subtitle: {
                text: ''
            },
            xAxis: {
                categories: ['CPA_0231', 'CPA_0230', 'CPA_0221', 'CPA_0222'],
                title: {
                    text: null
                },
                gridLineWidth: 1,
                lineWidth: 0
            },
            yAxis: {
                min: 0,
                title: {
                    text: '',
                    align: ''
                },
                labels: {
                    overflow: 'justify'
                },
                gridLineWidth: 0
            },
            tooltip: {
                valueSuffix: ' values'
            },
            plotOptions: {
                bar: {
                    borderRadius: '50%',
                    dataLabels: {
                        enabled: true
                    },
                    groupPadding: 0.1
                }
            },
            credits: {
                enabled: false
            },
            series: [{
                name: 'Year 1990',
                data: [100, 120, 80, 40]
            }, {
                name: 'Year 2000',
                data: [100, 120, 80, 40]
            }, {
                name: 'Year 2021',
                data: [100, 120, 80, 40]
            }]
        });
    

        Highcharts.chart('container2', {
            chart: {
                type: 'column'
            },
            title: {
                text: 'INDICADOR'
            },
            subtitle: {
                text:
                    ''
            },
            xAxis: {
                categories: ['I1', 'I2', 'I3', 'I4', 'I5', 'I6'],
                crosshair: true,
                accessibility: {
                    description: 'Valores'
                }
            },
            yAxis: {
                min: 0,
                title: {
                    text: ' metric '
                }
            },
            tooltip: {
                valueSuffix: ' (MT)'
            },
            plotOptions: {
                column: {
                    pointPadding: 0.2,
                    borderWidth: 0
                }
            },
            series: [
                {
                    name: 'V1',
                    data: [387749, 280000, 129000, 64300, 54000, 34300]
                },
                {
                    name: 'V2',
                    data: [45321, 140000, 10000, 140500, 19500, 113500]
                }
            ]
        });

        Highcharts.chart('container4', {
            chart: {
                type: 'column'
            },
            title: {
                text: 'Indicador'
            },
            xAxis: {
                categories: ['AWS1', 'AWS2', 'AWS3', 'AWS3', 'AWS5']
            },
            credits: {
                enabled: false
            },
            plotOptions: {
                column: {
                    borderRadius: '25%'
                }
            },
            series: [{
                name: 'v1',
                data: [5, 3, 4, 7, 2]
            }, {
                name: 'v2',
                data: [2, -2, -3, 2, 1]
            }, {
                name: 'v3',
                data: [3, 4, 4, -2, 5]
            }]
        });

// Bring life to the dials
setInterval(function () {
    // Speed
    let point,
        newVal,
        inc;

    if (chartSpeed) {
        point = chartSpeed.series[0].points[0];
        inc = Math.round((Math.random() - 0.5) * 100);
        newVal = point.y + inc;

        if (newVal < 0 || newVal > 200) {
            newVal = point.y - inc;
        }

        point.update(newVal);
    }

    // RPM
    if (chartRpm) {
        point = chartRpm.series[0].points[0];
        inc = Math.random() - 0.5;
        newVal = point.y + inc;

        if (newVal < 0 || newVal > 5) {
            newVal = point.y - inc;
        }

        point.update(newVal);
    }
}, 2000);
    </script>
 @endsection

 @section('style')
    <style>
        hr {
        height: 10px;
        }
    </style>
@endsection
