@extends('layouts.app')

@section('navigation')
    <a href="{{ route('users.index') }}" class="breadcrumb-item"><i class="icon-stack mr-2"></i> Usuarios</a>
    <span class="breadcrumb-item active">Editar registro</span>
@endsection

@section('content')
    <div class="content">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title" style="color:black; font-weight:bold;">Editar usuario</h5>
                <hr style="height:2px; background-color:#01015F;"></hr>
            </div>
            <div class="card-body">
                {!! Form::model($user, ['route' => ['users.update', $user->id], 'method' => 'patch', 'files' => true, 'id' => 'form-data']) !!}
                    @csrf
                    <div class="row">
                        <div class="form-group col-sm-6">
                            <h6><label for="name" class="col-form-label">Nombre completo:</label></h6>
                            {!! Form::text('name', null, ['class' => 'form-control', 'style' => 'margin-top:-10px', 'required' => true]) !!}
                        </div>

                        <!-- Email Field -->
                        <div class="form-group col-sm-6">
                            <h6><label for="email" class="col-form-label">Correo electrónico:</label></h6>
                            {!! Form::email('email', null, ['class' => 'form-control', 'style' => 'margin-top:-10px', 'autocomplete' => "off", 'required' => true]) !!}
                        </div>

                        <div class="form-group col-sm-6">
                            <h6><label for="roleId" class="col-form-label">Perfil de usuario:</label></h6>
                            {!! Form::select('roleId', \App\Models\Role::whereEnabled(1)->whereTrash(0)->pluck('name', 'id'), null,  [ 'class' => 'form-control select', 'placeholder' => '[ Seleccione ]' ]) !!}
                        </div>

                        <!-- Password Field -->
                        <div class="form-group col-sm-3">
                            <h6><label for="name" class="col-form-label">Contraseña:</label></h6>
                            {!! Form::password('password', ['class' => 'form-control', 'id' => 'password', 'required' => true]) !!}
                        </div>

                        <div class="form-group col-sm-3">
                            <h6><label for="name" class="col-form-label">Confirmar contraseña:</label></h6>
                            {!! Form::password('password2', ['class' => 'form-control',  'id' => 'password2']) !!}
                        </div>

                        <div class="form-group col-lg-12 col-12">
                            <hr style="height: 1px; background-color: #01015F;"></hr>
                            <div class="form-group col-12 col-lg-12" style="text-align:right;">
                                <a id="save-button" onclick="ValidarClave()" style="border-radius:5px; height:40px; width:150px; font-size:14px; color:#102360;"
                                 class="btn btn-outline-success btn-labeled btn-labeled-left"></b> Guardar<b><i class="fa fa-save"></i></a>

                                <a href="{{ route('users.index') }}" style="border-radius:5px; height:40px; width:150px; font-size:14px; color:#102360;"
                                class="btn btn-outline-warning btn-labeled btn-labeled-right"><b><i class="fa fa-reply"></i></b>Regresar</a>
                            </div>
                        </div>
                    </div>

                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        ValidarClave = function () {

            if($("#name").val() == ""){
                showError("Debe escribir su nombre, verifique...");
                return false;
            }

            if($("#password").val() != ""){
                if ($("#password").val() != $("#password2").val()) {
                    Swal.fire(
                        'Advertencia!',
                        'Las claves no coinciden, verifique...',
                        'error'
                    )
                    return false;
                }else{
                    $("#form-data").submit();
                }
            }else{
                $("#form-data").submit();
            }
        }

    </script>
@endsection
