<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::group([
    'middleware' => ['api'],
    'prefix' => 'auth'
], function ($router) {
    Route::post('login', 'Api\Auth\LoginController@login');
    Route::post('logout', 'Api\Auth\LoginController@logout')->name('close-seccion');
    Route::post('refresh', 'Api\Auth\LoginController@refresh');
    Route::post('me', 'Api\Auth\LoginController@me');
});

Route::group(['middleware' => ['cors']], function () {

    Route::prefix('v1')->group(function () {

    });

});
